<?php
/**
 * Plugin Name: ROI Master
 * Plugin URI: https://kredo-marketing.com/roi-master
 * Description: An advanced ROI calculator for marketing campaigns directly in WordPress.
 * Version: 2.7.2
 * Author: Kredo Marketing
 * Author URI: https://kredo-marketing.com/
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: roi-master
 */

// Impedisce l'accesso diretto al file.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Crea la voce di menu "ROI Master" nella bacheca di WP.
 */
function roima_calculator_menu() {
	add_menu_page(
		__( 'ROI Master', 'roi-master' ),
		__( 'ROI Master', 'roi-master' ),
		'manage_options',
		'roima-calculator',
		'roima_calculator_page',
		'dashicons-chart-line',
		20
	);
}
add_action( 'admin_menu', 'roima_calculator_menu' );

/**
 * Enqueue degli script necessari solo nella pagina del plugin.
 */
function roima_enqueue_scripts( $hook ) {
	if ( $hook !== 'toplevel_page_roima-calculator' ) {
		return;
	}

	// Enqueue PDFObject (incluso localmente)
	wp_register_script(
		'pdfobject',
		plugins_url( 'assets/pdfobject.min.js', __FILE__ ),
		array(),
		'2.1.1',
		true
	);
	wp_enqueue_script( 'pdfobject' );

	// Enqueue jsPDF aggiornato alla versione stabile (assicurarsi che il file sia aggiornato)
	wp_register_script(
		'jspdf',
		plugins_url( 'assets/jspdf.umd.min.js', __FILE__ ),
		array(),
		'2.5.1',
		true
	);
	wp_enqueue_script( 'jspdf' );

	// Enqueue il file JS personalizzato che gestisce il form e la generazione del PDF
	wp_register_script(
		'roi-master-js',
		plugins_url( 'assets/js/roi-master.js', __FILE__ ),
		array( 'pdfobject', 'jspdf' ),
		'1.0.0',
		true
	);
	wp_enqueue_script( 'roi-master-js' );
}
add_action( 'admin_enqueue_scripts', 'roima_enqueue_scripts' );

/**
 * Contenuto della pagina del plugin.
 */
function roima_calculator_page() {
	?>
	<div class="wrap">
		<img 
			src="<?php echo esc_url( plugins_url( 'assets/Kredo-logo-mail.svg', __FILE__ ) ); ?>" 
			alt="<?php esc_attr_e( 'Kredo Marketing Logo', 'roi-master' ); ?>" 
			style="width:80px; float:left; margin-right:20px;"
		>
		<h1><?php esc_html_e( 'Marketing ROI Calculator', 'roi-master' ); ?></h1>
		<form id="roi-calculator-form" style="max-width:500px; display: flex; flex-direction: column; gap: 10px;">
			<label for="investment"> <?php esc_html_e( 'Investment (€):', 'roi-master' ); ?> </label>
			<input type="number" id="investment" name="investment" required>

			<label for="revenue"> <?php esc_html_e( 'Revenue (€):', 'roi-master' ); ?> </label>
			<input type="number" id="revenue" name="revenue" required>

			<label for="cac"> <?php esc_html_e( 'Customer Acquisition Cost (CAC) (€):', 'roi-master' ); ?> </label>
			<input type="number" id="cac" name="cac" required>

			<label for="ltv"> <?php esc_html_e( 'Lifetime Value (LTV) (€):', 'roi-master' ); ?> </label>
			<input type="number" id="ltv" name="ltv" required>

			<label for="leads"> <?php esc_html_e( 'Number of Leads Generated:', 'roi-master' ); ?> </label>
			<input type="number" id="leads" name="leads" required>

			<label for="time-period"> <?php esc_html_e( 'Campaign Duration (days):', 'roi-master' ); ?> </label>
			<input type="number" id="time-period" name="time-period" required>

			<button type="submit" class="button button-primary" style="margin-top: 15px;">
				<?php esc_html_e( 'Calculate ROI', 'roi-master' ); ?>
			</button>
		</form>

		<h3><?php esc_html_e( 'Result:', 'roi-master' ); ?> <span id="roi-result">---</span></h3>
		<h4 id="roi-evaluation"></h4>

		<button id="download-pdf" class="button button-secondary" style="margin-top: 15px;">
			<?php esc_html_e( 'Download PDF Report', 'roi-master' ); ?>
		</button>
	</div>
	<?php
}