(function() {
    const form = document.getElementById('roi-calculator-form');
    const resultSpan = document.getElementById('roi-result');
    const evaluationEl = document.getElementById('roi-evaluation');
    const downloadBtn = document.getElementById('download-pdf');

    form.addEventListener('submit', function(event) {
        event.preventDefault();
        const investment = parseFloat(document.getElementById('investment').value) || 0;
        const revenue = parseFloat(document.getElementById('revenue').value) || 0;
        const roi = (investment > 0) ? ((revenue - investment) / investment) * 100 : 0;
        resultSpan.innerText = roi.toFixed(2) + '%';
        evaluationEl.innerText = roi < 20 
            ? "Your ROI is low. Consider revising your marketing strategies." 
            : (roi < 70 
                ? "Your ROI is decent. Keep optimizing for better results." 
                : "Great job! Your ROI is excellent.");
    });

    downloadBtn.addEventListener('click', function() {
        const { jsPDF } = window.jspdf;
        const doc = new jsPDF();
        doc.setFont("helvetica");
        doc.setFontSize(18);
        doc.text("Marketing ROI Report", 20, 40);
        doc.setFontSize(14);
        doc.text("Investment (€): " + document.getElementById('investment').value, 20, 60);
        doc.text("Revenue (€): " + document.getElementById('revenue').value, 20, 70);
        doc.text("ROI: " + resultSpan.innerText, 20, 80);
        doc.text(evaluationEl.innerText, 20, 90);
        doc.save("ROI_Report.pdf");
    });
})();